#define  YYDEBUG 0  
#include "xtypedef.h"
#include "yacc_def.h"
#include "xpatlex.h"





extern bx_int8  yy_patt_parse_dest;
extern bx_int8  err_flag;


typedef union  {
         t_numval num_value;
         t_signal_idx  signal_idx;
         bx_int32  int_value;
       } YYSTYPE;
#ifdef __cplusplus
#  include <stdio.h>
#  include <yacc.h>
#endif	/* __cplusplus */ 
# define SIGNAL 257
# define ERR_SIGNAL 258
# define TOGGLE 259
# define DEC_NUMBER 260
# define HEX_NUMBER 261
# define BIN_NUMBER 262
# define SIGNAL_VECTOR 263
# define SIGNAL_LIST 264
# define EQU 265
# define UNDEF_TOKEN 266
# define CONST_0 267
# define CONST_1 268
# define DONT_CARE 269
# define TOGGLE_ALL 270
#define yy_patt_clearin yy_patt_char = -1
#define yy_patt_errok yy_patt_errflag = 0
extern int yy_patt_char;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif

/* __YYSCLASS defines the scoping/storage class for global objects
 * that are NOT renamed by the -p option.  By default these names
 * are going to be 'static' so that multi-definition errors
 * will not occur with multiple parsers.
 * If you want (unsupported) access to internal names you need
 * to define this to be null so it implies 'extern' scope.
 * This should not be used in conjunction with -p.
 */
#ifndef __YYSCLASS
# define __YYSCLASS static
#endif
YYSTYPE yy_patt_lval;
__YYSCLASS YYSTYPE yy_patt_val;
typedef int yy_patt_tabelem;
# define YYERRCODE 256


/**************************************************************
 *
 *  generates a bit mask with ones from 'from' to 'downto' 
 *
 **************************************************************/

bx_int32 mask_bitvector(bx_int32 from,bx_int32 downto)
{
  bx_int32 i;
  bx_int32 mask = 0x0;

  if(from < downto)
     {
       yy_patt_error("\nError in vector range\n");
       return(mask);
     }

  for(i = downto; i <= from; i++)
     mask |= (0x1 << i);
  return(mask);
}

/*******************************************************
*
*    decodes the C_and DC_value of signal index and
*    does a shift to the correct position
*
********************************************************/


t_signal_idx decode_list(t_signal_idx signal_idx)
{
  bx_int32 i;
  bx_int32 c_value;
  bx_int32 dc_value;

  /* all dc bits in value are set to zero */
  c_value = signal_idx.C_value & (~(signal_idx.DC_value));
  dc_value = 0x0;

  /* set every bit of dc_value to one as indicated in C_value and DC_value */
  for (i=0; i<signal_idx.Length;i++)
  {
    if (( i&(~(signal_idx.DC_value))) == c_value)
    {
      dc_value |= (0x1<<i);
    }
  }
  /* do the shifting to correct position and set all other bits in the DWORD to don't care */
  signal_idx.DC_value = (dc_value  << signal_idx.Position) |
    (~(mask_bitvector(signal_idx.Position+signal_idx.Length-1,signal_idx.Position)));
  signal_idx.C_value = ~(mask_bitvector(signal_idx.Position+signal_idx.Length-1,signal_idx.Position));
  return (signal_idx);
}

void set_signal(t_signal_idx signal_idx)
{
  bx_int32 bit_mask;

      DBG_OUT(("Setting signal:\n"));
      DBG_OUT(("  Type: %4d, Position: %4d, Index: %4d,Length: %4d\n",
	      signal_idx.Type, signal_idx.Position,
	      signal_idx.Index, signal_idx.Length));
      DBG_OUT(("\n"));
      DBG_OUT(("                      DC_Value: C_Value:\n"));
      DBG_OUT(("  Signal            : %08X  %08X\n", signal_idx.DC_value, signal_idx.C_value));
      DBG_OUT(("  Old Pattern(Index): %08X  %08X\n",dc_pattern[signal_idx.Index],c_pattern[signal_idx.Index]));
      
  

  /* check if term results in global zero */
  /* bit_mask has ones where old pattern and new signal_idx are both not don't care */
  bit_mask = ~(dc_pattern[signal_idx.Index] | signal_idx.DC_value);

  if (signal_idx.Type == LISTTYPE) 
  {
    
    /* check if setting results in global zero is not necessary */
    /* because pterm results automatically to zero if all */
    /* decoded bits have to be zero at the same time */
    
    dc_pattern[signal_idx.Index] = dc_pattern[signal_idx.Index] & signal_idx.DC_value;
    c_pattern[signal_idx.Index]  = c_pattern[signal_idx.Index]  & signal_idx.C_value;
  }
  else  if ( (c_pattern[signal_idx.Index] & bit_mask) != (signal_idx.C_value & bit_mask))
  {
    /*  set global zero bit */
    global_zero = BX_TRUE;
    DBG_OUT(("Setting global zero bit in set_signal (NOLISTTYPE)\n")); 
  }
  else
  {
    c_pattern[signal_idx.Index]  = (dc_pattern[signal_idx.Index] | c_pattern[signal_idx.Index]) &
      				   (signal_idx.DC_value | signal_idx.C_value);
    dc_pattern[signal_idx.Index] = dc_pattern[signal_idx.Index] & signal_idx.DC_value;
  }
      DBG_OUT(("  New Pattern(Index): %08X  %08X\n",dc_pattern[signal_idx.Index],
	      c_pattern[signal_idx.Index]));
      DBG_OUT(("\n"));
    

}


void add_signal(t_signal_idx signal_idx)
{
  bx_int32 dc_value;
  
      DBG_OUT(("Adding signal:\n"));
      DBG_OUT(("  Type: %4d, Position: %4d, Index: %4d,Length: %4d\n",
	      signal_idx.Type, signal_idx.Position,
	      signal_idx.Index, signal_idx.Length));
      DBG_OUT(("\n"));
      DBG_OUT(("                      DC_Value: C_Value:\n"));
      DBG_OUT(("  Signal            : %08X  %08X\n", signal_idx.DC_value, signal_idx.C_value));
      DBG_OUT(("  Old Pattern(Index): %08X  %08X\n",dc_pattern[signal_idx.Index],c_pattern[signal_idx.Index]));
  if (signal_idx.Type == VECTORTYPE)
  {
    dc_pattern[signal_idx.Index] = dc_pattern[signal_idx.Index] & signal_idx.DC_value;
  }
  else if (signal_idx.Type == LISTTYPE)
  {
    dc_value = ~(mask_bitvector(signal_idx.Position+signal_idx.Length-1,signal_idx.Position));
    dc_pattern[signal_idx.Index] = (dc_pattern[signal_idx.Index] & dc_value);
  }
  else
  {
    /* Bit signal */
    dc_value = ~(0x1 << signal_idx.Position);
    dc_pattern[signal_idx.Index] = (dc_pattern[signal_idx.Index] & dc_value);
  }
      DBG_OUT(("  New Pattern(Index): %08X  %08X\n",dc_pattern[signal_idx.Index],
	      c_pattern[signal_idx.Index]));
      DBG_OUT(("\n"));
 
  
}

/* initialize transitional patterm term so that it is sensitive to all */
/* signals                                                             */

void add_allsig()
{
 bx_int8 i;

 for (i=0; i<BX_PATTARR_SIZE; i++)
 {
   dc_pattern[i] = 0x0;
 }
}


void mk_signal(t_signal_idx  a)
{
  if(a.Type == LISTTYPE)
    set_signal(a);
}

t_signal_idx chk_lst_fct(t_signal_idx a, t_signal_idx b)
{
  t_signal_idx retval;
  retval.Type = LISTTYPE;

  if(a.Type != LISTTYPE || b.Type != LISTTYPE)
  {
    err_flag = SYNTAX_ERROR;
    yy_patt_error(NULL);
  }
  else 
    if ((a.Index != b.Index) || (a.Position !=b.Position))
    {
      err_flag = MORE_THAN_ONE_LISTSIGNAL;
      yy_patt_error(NULL);
    }
    else
    {
      retval.C_value = a.C_value;
      retval.DC_value = a.DC_value | b.DC_value;
      retval.Type = LISTTYPE;
      retval.Length = a.Length;
      retval.Position = a.Position;
      retval.Index = a.Index;
      
    }
  
  return  retval;
}
__YYSTCLASS yy_patt_tabelem yy_patt_exca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 42
# define YYLAST 251
__YYSTCLASS yy_patt_tabelem yy_patt_act[]={

    16,    31,    43,    44,    45,    38,    30,     6,    24,    47,
    46,    41,    53,    52,    54,     6,    27,    13,    40,    49,
    48,    50,    26,    66,    61,    36,    28,    29,    29,    28,
    22,    20,    20,    63,    37,    58,    60,    64,    57,    56,
    55,    25,    20,    19,    42,     3,     4,     2,     5,     1,
    59,     7,    23,    12,    39,     8,     9,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    33,    34,    32,    35,
     0,     0,     0,     0,     0,    51,     0,     0,     0,     0,
     0,     0,    62,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    65,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    21,    21,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,    15,    18,    13,     0,     0,     0,
    17,    14,    15,     0,    11,    10,     0,     0,    17,    14,
     0,     0,    11,    10,     0,     0,     0,     0,     0,     0,
    18 };
__YYSTCLASS yy_patt_tabelem yy_patt_pact[]={

   -33, -3000,     5,    -6,   -94, -3000,   -25, -3000, -3000, -3000,
 -3000, -3000, -3000,     1,  -243,  -249,  -231,  -259,  -264,  -242,
   -25,   -25,    -8,    -7,  -228,  -252,  -258,  -248, -3000, -3000,
  -258,  -255, -3000, -3000,     4, -3000,  -230, -3000,    -1,    -2,
    -3,   -56, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,  -236,   -11,
 -3000,   -21, -3000,  -236,  -237, -3000, -3000 };
__YYSTCLASS yy_patt_tabelem yy_patt_pgo[]={

     0,    56,    55,    54,    45,    53,    46,    51,    50,    36,
    44,    49,    47,    48 };
__YYSTCLASS yy_patt_tabelem yy_patt_r1[]={

     0,    11,    11,    11,     4,     4,     4,     4,     4,     4,
     4,     4,     2,     2,     2,     2,     2,     1,     7,    10,
    10,    10,    10,    10,    12,    12,    13,    13,    13,     3,
     3,     8,     8,     9,     9,     6,     6,     5,     5,     5,
     5,     5 };
__YYSTCLASS yy_patt_tabelem yy_patt_r2[]={

     0,     3,     3,     3,     7,     7,     7,     3,     3,     3,
     3,     3,     7,     3,     7,     5,     7,     7,     7,     3,
     3,     3,     3,     3,     6,     2,     9,     9,     9,     9,
     3,     7,     3,     7,     3,     7,     3,     7,     3,     7,
     5,     7 };
__YYSTCLASS yy_patt_tabelem yy_patt_chk[]={

 -3000,   -11,   -12,    -4,    -6,   -13,    40,    -7,    -2,    -1,
   268,   267,    -5,   259,   264,   257,    33,   263,   258,    38,
    38,   124,   124,    -4,    33,    40,   265,   265,   257,   258,
   265,   265,   -13,    -4,    -4,    -6,    33,    41,   257,    -3,
   270,   263,   -10,   260,   261,   262,   268,   267,   268,   267,
   269,   -10,   268,   267,   269,    41,    41,    41,    91,    -8,
    -9,   260,    93,    44,    58,    -9,   260 };
__YYSTCLASS yy_patt_tabelem yy_patt_def[]={

     0,    -2,     1,     2,     3,    25,     0,     7,     8,     9,
    10,    11,    36,     0,     0,    13,     0,     0,    38,     0,
     0,     0,     0,     0,     0,     0,     0,     0,    15,    40,
     0,     0,    24,     4,     6,    35,     0,     5,     0,     0,
     0,    30,    18,    19,    20,    21,    22,    23,    12,    14,
    16,    17,    37,    39,    41,    26,    27,    28,     0,     0,
    32,    34,    29,     0,     0,    31,    33 };
typedef struct { char *t_name; int t_val; } yy_patt_toktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

__YYSTCLASS yy_patt_toktype yy_patt_toks[] =
{
	"SIGNAL",	257,
	"ERR_SIGNAL",	258,
	"TOGGLE",	259,
	"DEC_NUMBER",	260,
	"HEX_NUMBER",	261,
	"BIN_NUMBER",	262,
	"SIGNAL_VECTOR",	263,
	"SIGNAL_LIST",	264,
	"EQU",	265,
	"UNDEF_TOKEN",	266,
	"CONST_0",	267,
	"CONST_1",	268,
	"DONT_CARE",	269,
	"TOGGLE_ALL",	270,
	"|",	124,
	"^",	94,
	"&",	38,
	"!",	33,
	"-unknown-",	-1	/* ends search */
};

__YYSTCLASS char * yy_patt_reds[] =
{
	"-no such reduction-",
	"pt_map : dpt_map",
	"pt_map : spt_map",
	"pt_map : ept_map",
	"spt_map : spt_map '&' spt_map",
	"spt_map : '(' spt_map ')'",
	"spt_map : spt_map '|' spt_map",
	"spt_map : signal_lt",
	"spt_map : signal_s",
	"spt_map : signal_v",
	"spt_map : CONST_1",
	"spt_map : CONST_0",
	"signal_s : SIGNAL EQU CONST_1",
	"signal_s : SIGNAL",
	"signal_s : SIGNAL EQU CONST_0",
	"signal_s : '!' SIGNAL",
	"signal_s : SIGNAL EQU DONT_CARE",
	"signal_v : SIGNAL_VECTOR EQU vec_value",
	"signal_lt : SIGNAL_LIST EQU vec_value",
	"vec_value : DEC_NUMBER",
	"vec_value : HEX_NUMBER",
	"vec_value : BIN_NUMBER",
	"vec_value : CONST_1",
	"vec_value : CONST_0",
	"dpt_map : dpt_map '&' signal_t",
	"dpt_map : signal_t",
	"signal_t : TOGGLE '(' SIGNAL ')'",
	"signal_t : TOGGLE '(' signal_vec ')'",
	"signal_t : TOGGLE '(' TOGGLE_ALL ')'",
	"signal_vec : SIGNAL_VECTOR '[' vec_range ']'",
	"signal_vec : SIGNAL_VECTOR",
	"vec_range : vec_range ',' bit_range",
	"vec_range : bit_range",
	"bit_range : DEC_NUMBER ':' DEC_NUMBER",
	"bit_range : DEC_NUMBER",
	"ept_map : ept_map '|' ept_map",
	"ept_map : err_signal",
	"err_signal : ERR_SIGNAL EQU CONST_1",
	"err_signal : ERR_SIGNAL",
	"err_signal : ERR_SIGNAL EQU CONST_0",
	"err_signal : '!' ERR_SIGNAL",
	"err_signal : ERR_SIGNAL EQU DONT_CARE",
};
#endif /* YYDEBUG */
#define YYFLAG  (-3000)
/* @(#) $Revision: 70.7 $ */    

/*
** Skeleton parser driver for yacc output
*/

#if defined(NLS) && !defined(NL_SETN)
#if defined(_AIX)
#include <sys/msgbuf.h>
#else
#include <msgbuf.h>
#endif
#endif

#ifndef nl_msg
#define nl_msg(i,s) (s)
#endif

/*
** yacc user known macros and defines
*/
/* #define YYERROR		goto yy_patt_errlab */

#ifndef __RUNTIME_YYMAXDEPTH
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#else
#define YYACCEPT	{free_stacks(); return(0);}
#define YYABORT		{free_stacks(); return(1);}
#endif

#if 0
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yy_patt_char >= 0 || ( yy_patt_r2[ yy_patt_tmp ] >> 1 ) != 1 )\
	{\
		yy_patt_error( (nl_msg(30001,"syntax error - cannot backup")) );\
		goto yy_patt_errlab;\
	}\
	yy_patt_char = newtoken;\
	yy_patt_state = *yy_patt_ps;\
	yy_patt_lval = newvalue;\
	goto yy_patt_newstate;\
}
#endif

#define YYRECOVERING()	(!!yy_patt_errflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yy_patt_debug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
/* define for YYFLAG now generated by yacc program. */
/*#define YYFLAG		(FLAGVAL)*/

/*
** global variables used by the parser
*/
# ifndef __RUNTIME_YYMAXDEPTH
__YYSCLASS YYSTYPE yy_patt_v[ YYMAXDEPTH ];	/* value stack */
__YYSCLASS int yy_patt_s[ YYMAXDEPTH ];		/* state stack */
# else
__YYSCLASS YYSTYPE *yy_patt_v;			/* pointer to malloc'ed value stack */
__YYSCLASS int *yy_patt_s;			/* pointer to malloc'ed stack stack */

#if defined(__STDC__) || defined (__cplusplus)
#include <stdlib.h>
#else
	extern char *BestXMemMalloc();
	extern char *BestXMemRealloc();
	extern void BestXFree();
#endif /* __STDC__ or __cplusplus */


static int allocate_stacks(); 
static void free_stacks();
# ifndef YYINCREMENT
# define YYINCREMENT (YYMAXDEPTH/2) + 10
# endif
# endif	/* __RUNTIME_YYMAXDEPTH */
long  yy_patt_maxdepth ;

__YYSCLASS YYSTYPE *yy_patt_pv;			/* top of value stack */
__YYSCLASS int *yy_patt_ps;			/* top of state stack */

__YYSCLASS int yy_patt_state;			/* current state */
__YYSCLASS int yy_patt_tmp;			/* extra var (lasts between blocks) */

int yy_patt_nerrs;			/* number of errors */
__YYSCLASS int yy_patt_errflag;			/* error recovery flag */
int yy_patt_char;			/* current input token number */



/*
** yy_patt_parse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yy_patt_parse()
{
	register YYSTYPE *yy_patt_pvt;	/* top of value stack for $vars */

	/*
	** Initialize externals - yy_patt_parse may be called more than once
	*/
# ifdef __RUNTIME_YYMAXDEPTH
	if (allocate_stacks()) YYABORT;
# endif
	yy_patt_pv = &yy_patt_v[-1];
	yy_patt_ps = &yy_patt_s[-1];
	yy_patt_state = 0;
	yy_patt_tmp = 0;
	yy_patt_nerrs = 0;
	yy_patt_errflag = 0;
	yy_patt_char = -1;

	goto yy_patt_stack;
	{
		register YYSTYPE *yy_patt__pv;	/* top of value stack */
		register int *yy_patt__ps;		/* top of state stack */
		register int yy_patt__state;		/* current state */
		register int  yy_patt__n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
/* 	yy_patt_newstate: */
		yy_patt__pv = yy_patt_pv;
		yy_patt__ps = yy_patt_ps;
		yy_patt__state = yy_patt_state;
		goto yy_patt__newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yy_patt_stack:
		yy_patt__pv = yy_patt_pv;
		yy_patt__ps = yy_patt_ps;
		yy_patt__state = yy_patt_state;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_patt__stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yy_patt_debug )
		{
			register int yy_patt__i;

			printf( "State %d, token ", yy_patt__state );
			if ( yy_patt_char == 0 )
				printf( "end-of-file\n" );
			else if ( yy_patt_char < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_patt__i = 0; yy_patt_toks[yy_patt__i].t_val >= 0;
					yy_patt__i++ )
				{
					if ( yy_patt_toks[yy_patt__i].t_val == yy_patt_char )
						break;
				}
				printf( "%s\n", yy_patt_toks[yy_patt__i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_patt__ps >= &yy_patt_s[ yy_patt_maxdepth ] )	/* room on stack? */
		{
# ifndef __RUNTIME_YYMAXDEPTH
			yy_patt_error( (nl_msg(30002,"yacc stack overflow")) );
			YYABORT;
# else
			/* save old stack bases to recalculate pointers */
			YYSTYPE * yy_patt_v_old = yy_patt_v;
			int * yy_patt_s_old = yy_patt_s;
			yy_patt_maxdepth += YYINCREMENT;
			yy_patt_s = (int *) BestXMemRealloc(yy_patt_s, yy_patt_maxdepth * sizeof(int));
			yy_patt_v = (YYSTYPE *) BestXMemRealloc(yy_patt_v, yy_patt_maxdepth * sizeof(YYSTYPE));
			if (yy_patt_s==0 || yy_patt_v==0) {
			    yy_patt_error( (nl_msg(30002,"yacc stack overflow")) );
			    YYABORT;
			    }
			/* Reset pointers into stack */
			yy_patt__ps = (yy_patt__ps - yy_patt_s_old) + yy_patt_s;
			yy_patt_ps = (yy_patt_ps - yy_patt_s_old) + yy_patt_s;
			yy_patt__pv = (yy_patt__pv - yy_patt_v_old) + yy_patt_v;
			yy_patt_pv = (yy_patt_pv - yy_patt_v_old) + yy_patt_v;
# endif

		}
		*yy_patt__ps = yy_patt__state;
		*++yy_patt__pv = yy_patt_val;

		/*
		** we have a new state - find out what to do
		*/
	yy_patt__newstate:
		if ( ( yy_patt__n = yy_patt_pact[ yy_patt__state ] ) <= YYFLAG )
			goto yy_patt_default;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yy_patt_tmp = yy_patt_char < 0;
#endif
		if ( ( yy_patt_char < 0 ) && ( ( yy_patt_char = yy_patt_lex() ) < 0 ) )
			yy_patt_char = 0;		/* reached EOF */
#if YYDEBUG
		if ( yy_patt_debug && yy_patt_tmp )
		{
			register int yy_patt__i;

			printf( "Received token " );
			if ( yy_patt_char == 0 )
				printf( "end-of-file\n" );
			else if ( yy_patt_char < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_patt__i = 0; yy_patt_toks[yy_patt__i].t_val >= 0;
					yy_patt__i++ )
				{
					if ( yy_patt_toks[yy_patt__i].t_val == yy_patt_char )
						break;
				}
				printf( "%s\n", yy_patt_toks[yy_patt__i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_patt__n += yy_patt_char ) < 0 ) || ( yy_patt__n >= YYLAST ) )
			goto yy_patt_default;
		if ( yy_patt_chk[ yy_patt__n = yy_patt_act[ yy_patt__n ] ] == yy_patt_char )	/*valid shift*/
		{
			yy_patt_char = -1;
			yy_patt_val = yy_patt_lval;
			yy_patt__state = yy_patt__n;
			if ( yy_patt_errflag > 0 )
				yy_patt_errflag--;
			goto yy_patt__stack;
		}

	yy_patt_default:
		if ( ( yy_patt__n = yy_patt_def[ yy_patt__state ] ) == -2 )
		{
#if YYDEBUG
			yy_patt_tmp = yy_patt_char < 0;
#endif
			if ( ( yy_patt_char < 0 ) && ( ( yy_patt_char = yy_patt_lex() ) < 0 ) )
				yy_patt_char = 0;		/* reached EOF */
#if YYDEBUG
			if ( yy_patt_debug && yy_patt_tmp )
			{
				register int yy_patt__i;

				printf( "Received token " );
				if ( yy_patt_char == 0 )
					printf( "end-of-file\n" );
				else if ( yy_patt_char < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_patt__i = 0;
						yy_patt_toks[yy_patt__i].t_val >= 0;
						yy_patt__i++ )
					{
						if ( yy_patt_toks[yy_patt__i].t_val
							== yy_patt_char )
						{
							break;
						}
					}
					printf( "%s\n", yy_patt_toks[yy_patt__i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				const int *yy_patt_xi = yy_patt_exca;

				while ( ( *yy_patt_xi != -1 ) ||
					( yy_patt_xi[1] != yy_patt__state ) )
				{
					yy_patt_xi += 2;
				}
				while ( ( *(yy_patt_xi += 2) >= 0 ) &&
					( *yy_patt_xi != yy_patt_char ) )
					;
				if ( ( yy_patt__n = yy_patt_xi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_patt__n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yy_patt_errflag )
			{
			case 0:		/* new error */
				yy_patt_error( (nl_msg(30003,"syntax error")) );
				yy_patt_nerrs++;
				goto skip_init;
			/* yy_patt_errlab: */
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_patt__pv = yy_patt_pv;
				yy_patt__ps = yy_patt_ps;
				yy_patt__state = yy_patt_state;
				yy_patt_nerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yy_patt_errflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_patt__ps >= yy_patt_s )
				{
					yy_patt__n = yy_patt_pact[ *yy_patt__ps ] + YYERRCODE;
					if ( yy_patt__n >= 0 && yy_patt__n < YYLAST &&
						yy_patt_chk[yy_patt_act[yy_patt__n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_patt__state = yy_patt_act[ yy_patt__n ];
						goto yy_patt__stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yy_patt_debug )
						printf( _POP_, *yy_patt__ps,
							yy_patt__ps[-1] );
#	undef _POP_
#endif
					yy_patt__ps--;
					yy_patt__pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yy_patt_debug )
				{
					register int yy_patt__i;

					printf( "Error recovery discards " );
					if ( yy_patt_char == 0 )
						printf( "token end-of-file\n" );
					else if ( yy_patt_char < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_patt__i = 0;
							yy_patt_toks[yy_patt__i].t_val >= 0;
							yy_patt__i++ )
						{
							if ( yy_patt_toks[yy_patt__i].t_val
								== yy_patt_char )
							{
								break;
							}
						}
						printf( "token %s\n",
							yy_patt_toks[yy_patt__i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yy_patt_char == 0 )	/* reached EOF. quit */
					YYABORT;
				yy_patt_char = -1;
				goto yy_patt__newstate;
			}
		}/* end if ( yy_patt__n == 0 ) */
		/*
		** reduction by production yy_patt__n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yy_patt_debug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_patt__n, yy_patt_reds[ yy_patt__n ] );
#endif
		yy_patt_tmp = yy_patt__n;			/* value to switch over */
		yy_patt_pvt = yy_patt__pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_patt__state here as temporary
		** register variable, but why not, if it works...
		** If yy_patt_r2[ yy_patt__n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_patt__stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_patt__len = yy_patt_r2[ yy_patt__n ];

			if ( !( yy_patt__len & 01 ) )
			{
				yy_patt__len >>= 1;
				yy_patt_val = ( yy_patt__pv -= yy_patt__len )[1];	/* $$ = $1 */
				yy_patt__state = yy_patt_pgo[ yy_patt__n = yy_patt_r1[ yy_patt__n ] ] +
					*( yy_patt__ps -= yy_patt__len ) + 1;
				if ( yy_patt__state >= YYLAST ||
					yy_patt_chk[ yy_patt__state =
					yy_patt_act[ yy_patt__state ] ] != -yy_patt__n )
				{
					yy_patt__state = yy_patt_act[ yy_patt_pgo[ yy_patt__n ] ];
				}
				goto yy_patt__stack;
			}
			yy_patt__len >>= 1;
			yy_patt_val = ( yy_patt__pv -= yy_patt__len )[1];	/* $$ = $1 */
			yy_patt__state = yy_patt_pgo[ yy_patt__n = yy_patt_r1[ yy_patt__n ] ] +
				*( yy_patt__ps -= yy_patt__len ) + 1;
			if ( yy_patt__state >= YYLAST ||
				yy_patt_chk[ yy_patt__state = yy_patt_act[ yy_patt__state ] ] != -yy_patt__n )
			{
				yy_patt__state = yy_patt_act[ yy_patt_pgo[ yy_patt__n ] ];
			}
		}
					/* save until reenter driver code */
		yy_patt_state = yy_patt__state;
		yy_patt_ps = yy_patt__ps;
		yy_patt_pv = yy_patt__pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yy_patt_tmp )
	{
		
case 1:{ if(yy_patt_parse_dest!=TRAN_PATT)
  			            {
			               err_flag = WRONG_PARSEDEST_DPT;
			               yy_patt_error(NULL);
			            }
		             } break;
case 2:{ 
	                    mk_signal(yy_patt_pvt[-0].signal_idx); /* makes an set_signal if needed */
			
	                    if(yy_patt_parse_dest!=BUS_PATT && yy_patt_parse_dest!=OBS_PATT && yy_patt_parse_dest!=ERR_PATT)
  			            {
			               err_flag = WRONG_PARSEDEST_SPT;
			               yy_patt_error(NULL);
			            }
		             } break;
case 3:{
                       ;
                    } break;
case 4:{ mk_signal(yy_patt_pvt[-2].signal_idx); mk_signal(yy_patt_pvt[-0].signal_idx); yy_patt_val.signal_idx.Type = COMBTYPE; } break;
case 5:{ yy_patt_val.signal_idx = yy_patt_pvt[-1].signal_idx; } break;
case 6:{ yy_patt_val.signal_idx = chk_lst_fct(yy_patt_pvt[-2].signal_idx,yy_patt_pvt[-0].signal_idx); } break;
case 7:{ yy_patt_val.signal_idx = decode_list(yy_patt_pvt[-0].signal_idx); yy_patt_val.signal_idx.Type = LISTTYPE; } break;
case 8:{ set_signal(yy_patt_pvt[-0].signal_idx); yy_patt_val.signal_idx.Type = BITTYPE;   } break;
case 9:{ set_signal(yy_patt_pvt[-0].signal_idx); yy_patt_val.signal_idx.Type = VECTORTYPE;  } break;
case 10:{ /* empty */;  yy_patt_val.signal_idx.Type = BITTYPE;  } break;
case 11:{ global_zero = BX_TRUE; yy_patt_val.signal_idx.Type = BITTYPE; } break;
case 12:{ yy_patt_val.signal_idx = yy_patt_pvt[-2].signal_idx;
				    (yy_patt_val.signal_idx).C_value = (bx_int32)(0x1 << (yy_patt_pvt[-2].signal_idx).Position);
				    (yy_patt_val.signal_idx).DC_value = ~((bx_int32)(0x1 << (yy_patt_pvt[-2].signal_idx).Position));
				  } break;
case 13:{ yy_patt_val.signal_idx = yy_patt_pvt[-0].signal_idx;
				    (yy_patt_val.signal_idx).C_value = (bx_int32)(0x1 << (yy_patt_pvt[-0].signal_idx).Position);
				    (yy_patt_val.signal_idx).DC_value = ~((bx_int32)(0x1 << (yy_patt_pvt[-0].signal_idx).Position));
				  } break;
case 14:{ yy_patt_val.signal_idx = yy_patt_pvt[-2].signal_idx;
				    (yy_patt_val.signal_idx).C_value = (bx_int32)(0);
				    (yy_patt_val.signal_idx).DC_value = ~((bx_int32)(0x1 << (yy_patt_pvt[-2].signal_idx).Position));
	  			  } break;
case 15:{ yy_patt_val.signal_idx = yy_patt_pvt[-0].signal_idx;
				    (yy_patt_val.signal_idx).C_value = (bx_int32)(0);
				    (yy_patt_val.signal_idx).DC_value = ~((bx_int32)(0x1 << (yy_patt_pvt[-0].signal_idx).Position));
	  			  } break;
case 16:{  yy_patt_val.signal_idx = yy_patt_pvt[-2].signal_idx;
	  			    (yy_patt_val.signal_idx).C_value =  (bx_int32)(0xFFFFFFFF);
				    (yy_patt_val.signal_idx).DC_value = (bx_int32)(0xFFFFFFFF);
 				  } break;
case 17:{ yy_patt_val.signal_idx = yy_patt_pvt[-2].signal_idx;
  					  yy_patt_val.signal_idx.C_value = (yy_patt_pvt[-0].num_value).c_bits << (yy_patt_pvt[-2].signal_idx).Position;
                                          yy_patt_val.signal_idx.DC_value = ((yy_patt_pvt[-0].num_value).dc_bits << (yy_patt_pvt[-2].signal_idx).Position) |
					    (~(mask_bitvector((yy_patt_pvt[-2].signal_idx).Position+(yy_patt_pvt[-2].signal_idx).Length-1,(yy_patt_pvt[-2].signal_idx).Position)));
			         	} break;
case 18:{ yy_patt_val.signal_idx = yy_patt_pvt[-2].signal_idx;
  					 (yy_patt_val.signal_idx).C_value = (yy_patt_pvt[-0].num_value).c_bits;
                                         (yy_patt_val.signal_idx).DC_value = (yy_patt_pvt[-0].num_value).dc_bits;
				       } break;
case 19:{ (yy_patt_val.num_value).c_bits = yy_patt_pvt[-0].int_value; (yy_patt_val.num_value).dc_bits= 0; } break;
case 20:{ yy_patt_val.num_value = yy_patt_pvt[-0].num_value; } break;
case 21:{ yy_patt_val.num_value = yy_patt_pvt[-0].num_value; } break;
case 22:{ (yy_patt_val.num_value).c_bits = 1; (yy_patt_val.num_value).dc_bits = 0; } break;
case 23:{ (yy_patt_val.num_value).c_bits = 0; (yy_patt_val.num_value).dc_bits = 0; } break;
case 26:{ add_signal(yy_patt_pvt[-1].signal_idx); } break;
case 27:{ add_signal(yy_patt_pvt[-1].signal_idx); } break;
case 28:{ add_allsig();   } break;
case 29:{ yy_patt_val.signal_idx = yy_patt_pvt[-3].signal_idx;
					       (yy_patt_val.signal_idx).DC_value = ~(yy_patt_pvt[-1].int_value << (yy_patt_pvt[-3].signal_idx).Position);
					      } break;
case 30:{ yy_patt_val.signal_idx = yy_patt_pvt[-0].signal_idx;
	  				       (yy_patt_val.signal_idx).DC_value =
						~(mask_bitvector((yy_patt_pvt[-0].signal_idx).Position+(yy_patt_pvt[-0].signal_idx).Length-1,(yy_patt_pvt[-0].signal_idx).Position));
					     } break;
case 31:{ yy_patt_val.int_value = yy_patt_pvt[-2].int_value | yy_patt_pvt[-0].int_value;} break;
case 32:{ yy_patt_val.int_value = yy_patt_pvt[-0].int_value; } break;
case 33:{ yy_patt_val.int_value = mask_bitvector(yy_patt_pvt[-2].int_value,yy_patt_pvt[-0].int_value); } break;
case 34:{ yy_patt_val.int_value = (0x1 << yy_patt_pvt[-0].int_value); } break;
case 35:{ } break;
case 36:{ set_signal(yy_patt_pvt[-0].signal_idx); yy_patt_val.signal_idx.Type = BITTYPE;   } break;
case 37:{ yy_patt_val.signal_idx = yy_patt_pvt[-2].signal_idx;
				    (yy_patt_val.signal_idx).C_value = (bx_int32)(0);
				    (yy_patt_val.signal_idx).DC_value = ~((bx_int32)(0x1 << (yy_patt_pvt[-2].signal_idx).Position));
				  } break;
case 38:{ yy_patt_val.signal_idx = yy_patt_pvt[-0].signal_idx;
				    (yy_patt_val.signal_idx).C_value = (bx_int32)(0);
				    (yy_patt_val.signal_idx).DC_value = ~((bx_int32)(0x1 << (yy_patt_pvt[-0].signal_idx).Position));
				  } break;
case 39:{ yy_patt_val.signal_idx = yy_patt_pvt[-2].signal_idx;
				    (yy_patt_val.signal_idx).C_value = (bx_int32)(0x1 << (yy_patt_pvt[-2].signal_idx).Position);
				    (yy_patt_val.signal_idx).DC_value = ~((bx_int32)(0x1 << (yy_patt_pvt[-2].signal_idx).Position));
	  			  } break;
case 40:{ yy_patt_val.signal_idx = yy_patt_pvt[-0].signal_idx;
				    (yy_patt_val.signal_idx).C_value = (bx_int32)(0x1 << (yy_patt_pvt[-0].signal_idx).Position);
				    (yy_patt_val.signal_idx).DC_value = ~((bx_int32)(0x1 << (yy_patt_pvt[-0].signal_idx).Position));
	  			  } break;
case 41:{  yy_patt_val.signal_idx = yy_patt_pvt[-2].signal_idx;
	  			    (yy_patt_val.signal_idx).C_value =  (bx_int32)(0xFFFFFFFF);
				    (yy_patt_val.signal_idx).DC_value = (bx_int32)(0xFFFFFFFF);
 				  } break;
	}
	goto yy_patt_stack;		/* reset registers in driver code */
}

# ifdef __RUNTIME_YYMAXDEPTH

static int allocate_stacks() {
	/* allocate the yy_patt_s and yy_patt_v stacks */
	yy_patt_s = (int *) BestXMemMalloc(yy_patt_maxdepth * sizeof(int));
	yy_patt_v = (YYSTYPE *) BestXMemMalloc(yy_patt_maxdepth * sizeof(YYSTYPE));

	if (yy_patt_s==0 || yy_patt_v==0) {
	   yy_patt_error( (nl_msg(30004,"unable to allocate space for yacc stacks")) );
	   return(1);
	   }
	else return(0);

}


static void free_stacks() {
	if (yy_patt_s!=0) BestXFree((char *) yy_patt_s);
	if (yy_patt_v!=0) BestXFree((char *) yy_patt_v);
}

# endif  /* defined(__RUNTIME_YYMAXDEPTH) */

